
alias -l _antidle.listNetworks {
  var %win = @_temp._antidle.listNetworks, %x = 1, %i, %total = $server(0)
  if ($window(%win)) { return %win }
  elseif (!%total) { return }
  window -hsl %win
  while ($server(%x).group) {
    %i = $ifmatch
    if (%i !isnum) && (!$fline(%win,%i,1)) { aline %win %i }
    inc %x
  }
  return %win
}
alias -l _antidle.getNetwork {
  var %dname = antidle.getNetwork, %net
  if ($dialog(%dname)) { return }
  %net = $dialog(%dname,%dname,-3)
  if (%net != $null) { return $ifmatch }
}
dialog -l antidle.getNetwork {
  title "Add network"
  size -1 -1 121 44
  option dbu
  box "", 1, 1 1 119 28
  button "&Select", 2, 45 31 37 12, ok default
  button "&Cancel", 3, 83 31 37 12, cancel
  combo 4, 6 10 110 100, size drop result edit
}
on *:DIALOG:antidle.getNetwork:*:*:{
  if ($devent == init) {
    if ($_antidle.listNetworks) { filter -wo $ifmatch $dname 4 }
    if ($didwm(4,$_network.active)) { did -c $dname 4 $ifmatch }
    else { did -c $dname 4 1 }
  }
  elseif ($devent == edit) && ($did == 4) { did $iif($did(4) != $null,-e,-b) $dname 2 }
}


;_____________[ Setup dialog ] ________________________________________

dialog -l antidle {
  title "Antidle options"
  size -1 -1 146 77
  option dbu

  text "Network", 1, 4 6 24 8
  combo 2, 29 5 56 50, size drop
  button "Add", 3, 85 5 28 10
  button "Remove", 4, 113 5 28 10

  box "", 5, 2 16 142 46
  check "Enable antidle", 6, 9 24 50 10
  check "Enable antidle while away", 7, 9 35 77 10
  text "Maximum seconds of idle time", 8, 10 48 74 8
  edit "", 9, 98 46 40 11, right

  button "&Ok", 100, 68 64 37 12, ok
  button "&Cancel", 99, 107 64 37 12, cancel

  edit "", 1000, 0 0 0 0, hide
}
on *:DIALOG:antidle:*:*:{
  if ($devent == init) { 
    didtok $dname 2 32 $_antidle.allNetworks
    did -c $dname 2 1
    _antidle.loadOptions
  }
  elseif ($devent == sclick) {
    if ($did == 2) { _antidle.loadOptions }
    if ($did == 3) {
      var %net = $$_antidle.getNetwork
      if ($didwm(2,%net)) { did -c $dname 2 $ifmatch }
      else { did -ca $dname 2 %net }
      _antidle.loadOptions
    }
    if ($did == 4) && ($did(2).seltext != $null) {
      var %text = $ifmatch
      if (%text != $chr(40) $+ Unknown $+ $chr(41)) && ($input(Do you really want to remove $+(',%text,') settings?,128,Antidle)) {
        _antidle.addToHash %text
        did -d $dname 2 $did(2).sel
        did -c $dname 2 1
        did -r $dname 1000
        _antidle.loadOptions
      }
    }
    if ($istok(99 100,$did,32)) { 
      _antidle.saveOptions 
      _antidle.work
    }
  }
}
alias -l _antidle.allNetworks {
  var %x = 1, %i, %nets = (Unknown), %chr = $iif($1 isnum,$1,32)
  while ($ini($_antidle.iniFile,%x)) {
    %nets = $addtok(%nets,$ifmatch,%chr)
    inc %x
  }
  return %nets
}
alias -l _antidle.iniFile { return $+(",$scriptdirAntidleOptions.ini,") }
alias -l _antidle.loadOptions {
  var %dname = antidle, %net = $did(%dname,2).seltext
  _antidle.saveOptions
  if (%net == $null) { return }
  did -u %dname 6,7
  if ($_antidle.option(%net,antidle)) { did -c %dname 6 }
  if ($_antidle.option(%net,antidle.while.away)) { did -c %dname 7 }
  did -ra %dname 9 $_antidle.maxTime(%net)
  did -ra %dname 1000 %net
}
alias -l _antidle.saveOptions {
  var %dname = antidle, %net = $did(%dname,1000), %a = _antidle.addToHash %net
  if (%net == $null) { return }
  %a antidle $did(%dname,6).state
  %a antidle.while.away $did(%dname,7).state
  %a antidle.max.idle $did(%dname,9)
}
alias -l _antidle.addToHash {
  var %f = $_antidle.iniFile
  if ($2 == $null) || ($3 == $null) { remini %f $1-2 }
  else { writeini %f $1- }
}
alias -l _antidle.option {
  if ($2) { var %net = $1, %option = $2 }
  else { var %net = $_antidle.activeNetwork, %option = $1 }
  if (%option == $null) { return }
  if (%net == $null) { %net = (Unknown) }
  return $readini($_antidle.iniFile,%net,%option)
}

alias -l _antidle.activeNetwork {
  if ($network) { return $ifmatch }
  if ($server($server).group) && ($ifmatch !isnum) { return $ifmatch }
  return Unknown
}
alias -l _antidle.identString {
  var %ident = $$1, %chr = $iif($2 isnum,$2,32), %x = 1, %str, %y = $scon(0)
  while (%x <= %y) {
    %str = $addtok(%str,$scon(%x). [ $+ [ %ident ] ],%chr)
    inc %x
  }
  return %str
}
alias -l _antidle.work {
  var %cids = $_antidle.identString(cid), %x = 1
  while ($gettok(%cids,%x,32)) {
    scid -t1 $ifmatch _antidle.timerHandler $ifmatch
    inc %x
  }
}
alias -l _antidle.maxTime { 
  var %r
  if ($1) { %r = $_antidle.option($1,antidle.max.idle) }
  else { %r = $_antidle.option(antidle.max.idle) }
  return $iif(%r isnum 1-,$ifmatch,20) 
}
alias -l _antidle.awayAffect {
  if ($away) && (!$_options(antidle.while.away)) { return 1 }
  return 0
}
alias -l _antidle.timerHandler {
  var %cid = $1, %timer = $+(ANTIDLE,~,%cid), %net = $scid(%cid).network
  if ($timer(%timer)) {
    if ($timer(%timer).delay != $_antidle.maxTime) { scid -t1 %cid .timer $+ %timer -o 0 $_antidle.maxTime _antidle.timerHandler %cid  }
    if (!$_antidle.option(antidle)) {
      .timer $+ %timer off
      return
    }
    if ($_antidle.awayAffect) { return }
    scid -t1 %cid resetidle
    scid -t1 %cid !.msg $scid(%cid).me ^_antidle_^
  }
  elseif ($_antidle.option(antidle)) { scid -t1 %cid .timer $+ %timer -o 0 $_antidle.maxTime _antidle.timerHandler %cid }
}
on me:^&*:OPEN:?:^_antidle_^:{ halt }
on ^*:TEXT:^_antidle_^:?:{
  if ($nick == $me) { halt }
}
on *:DISCONNECT:{ 
  if ($timer($+(ANTIDLE,~,$cid))) { .timer $+ $ifmatch off }
}
on *:CONNECT:{ _antidle.work }

alias antidle {
  if ($1 == -u) { 
    if ($input(Do you really want to unload Antidle v $+ $_antidle.version $+ ?,128,Antidle)) {
      .timerANTIDLE~* off 
      .timer -mi 1 1 unload -rs $+(",$script,")
    }
  }
  elseif ($1 == -o) || ($1 == $null) { 
    if ($dialog(antidle)) { dialog -ve antidle }
    else { dialog -mn antidle antidle }
  }
  elseif ($1 == -a) { }
  elseif ($1 == -r) { 
    var %f = $_antidle.readmeFile
    if ($isfile(%f)) { .run %f }
    else { echo $color(ctcp text) -ti2ae * /antidle: no readme file available ( $+ $mid(%f,2,-1) $+ ) }
  }
  else { echo $color(ctcp text) -ti2ea * /antidle: sintax error ( /antidle [-u|-o|-a|-r] ) }
}
alias -l _antidle.readmeFile { return $+(",$scriptdirAntidleReadme.txt,") }
alias -l _antidle.version { return 1.02 }

on *:LOAD:{
  if ($version < 6) {
    echo $color(ctcp text) -ti2ae * Antidle v $+ $_antidle.version $+  needs mIRC v6.0 or higher to run properly
    unload -rs $+(",$script,")
  }
  else { echo $color(info text) -ti2ae * Antidle v $+ $_antidle.version $+  loaded. Check menubar. }
}
