alias winampc_cfg { dialog -m winampc winampc }
dialog winampc {
  title "[ s.Winamp Control Configuration ]"
  size -1 -1 191 141
  option dbu
  button "Save", 2, 116 129 35 10, ok
  button "Cancel", 3, 153 129 35 10, cancel
  button "Test Config", 4, 2 129 60 10, default
  tab "Message", 6, 2 0 186 127
  box "Infos", 998, 6 28 178 84, tab 6
  edit "", 1, 31 17 142 10, tab 6 autohs
  edit "!Get", 5, 151 91 30 10, tab 6 autohs
  text "!ART = Artist Name", 101, 10 36 77 8, tab 6
  text "!TIT = Song Title", 102, 10 52 77 8, tab 6
  text "!ALB = Album Title", 103, 10 44 77 8, tab 6
  text "!R = Sample Rate (khz)", 105, 88 60 92 8, tab 6
  text "!B = Bitrate (kbps)", 106, 88 68 92 8, tab 6
  text "!POS = Track Position in the Playlist", 107, 88 84 92 8, tab 6
  text "!C = Song Comment", 108, 10 60 77 8, tab 6
  text "!DCC = DCC Send Trigger", 109, 88 92 63 8, tab 6
  text "!Z = File Size", 110, 10 100 77 8, tab 6
  text "!G = Song Genre", 112, 10 68 77 8, tab 6
  text "!Y = Song Year", 113, 10 76 77 8, tab 6
  text "!TL = Track length", 114, 88 44 92 8, tab 6
  text "!TP = Time of the track played", 115, 88 52 92 8, tab 6
  text "!PER = Percent of the track played", 125, 88 36 92 8, tab 6
  text "Message:", 995, 6 18 25 8, tab 6
  text "!V = Winamp Version", 111, 88 76 92 8, tab 6
  text "!EX = File Extension", 28, 10 84 77 8, tab 6
  text "!MS = Mono/Stereo", 29, 10 92 77 8, tab 6
  text "!FN = File Name", 30, 88 100 92 8, tab 6
  button "?", 31, 174 16 12 12, tab 6
  tab "Options", 7
  box "Message Setup", 999, 6 16 178 86, tab 7
  check "Say when song change to:", 20, 11 23 78 10, tab 7
  check "All Channels", 21, 91 24 50 8, tab 7
  check "/(a)msg", 23, 91 50 50 8, tab 7
  check "/(a)me", 24, 91 57 50 8, tab 7
  text "Command:", 996, 55 50 33 8, tab 7
  check "Active Channel", 22, 91 31 50 8, tab 7
  text "Time Display:", 994, 11 78 84 8, tab 7
  edit "#channel", 9, 119 39 50 10, tab 7 autohs
  check "Other:", 10, 91 39 28 9, tab 7
  box "Other", 25, 6 102 108 22, tab 7
  check "Put infos in mirc's titlebar", 26, 11 110 100 10, tab 7
  check "Say every", 27, 11 66 56 10, tab 7
  text "", 32, 139 67 43 8, tab 7
  scroll "", 33, 68 68 68 8, tab 7 range 1 40 horizontal top
  combo 34, 97 77 52 50, tab 7 size drop
  edit "", 35, 97 89 84 10, tab 7 autohs
  text "Winamp Stopped message:", 36, 11 90 85 8, tab 7
  button "Change Language", 489, 120 111 60 10, tab 7
  box "Language", 37, 117 102 67 22, tab 7
  tab "Options2", 8
  check "View (echo) Key", 12, 11 23 59 10, tab 8
  check "Display (say) Key", 15, 11 43 59 10, tab 8
  check "Alarm Clock Key", 116, 11 63 59 10, tab 8
  check "Remote Control Key", 120, 11 83 59 10, tab 8
  box "Keys", 11, 6 16 178 91, tab 8
  check "shift +", 14, 78 32 30 10, tab 8
  check "ctrl +", 13, 78 23 30 10, tab 8
  check "shift +", 17, 78 52 30 10, tab 8
  check "ctrl +", 16, 78 43 30 10, tab 8
  check "shift +", 118, 78 72 30 10, tab 8
  check "ctrl +", 117, 78 63 30 10, tab 8
  check "shift +", 122, 78 92 30 10, tab 8
  check "ctrl +", 121, 78 83 30 10, tab 8
  combo 18, 126 23 50 50, tab 8 size drop
  combo 19, 126 43 50 50, tab 8 size drop
  combo 119, 126 63 50 50, tab 8 size drop
  combo 123, 126 83 50 50, tab 8 size drop
}
alias -l winampc_loadup {
  did -r winampc $2
  set %temp 1
  while %temp <= 12 {
    if $isalias($1 $+ %temp) == $true && winampc_ !isin $isalias($1 $+ %temp).alias { goto next }
    did -a winampc $2 $1 $+ %temp
    :next
    inc %temp 1
  }
} 
alias winampc_uninstk {
  set %t F
  :start  
  set %temp 1
  while %temp <= 12 {
    if $isalias(%t $+ %temp) == $true && winampc_ isin $isalias(%t $+ %temp).alias { /alias %t $+ %temp }
    inc %temp 1
  }
  if %t == F { set %t cF | goto start }
  if %t == cF { set %t sF | goto start }
}
alias winampc_text { return $read(%winampc_cfg_language,$1) }
on 1:dialog:winampc:scroll:33:{ did -o $dname 32 1 $duration($calc($did(33).sel *30)) }
on 1:dialog:winampc:sclick:31:{ 
  echo -a You can use all the usual color tags & text styles as you use into mIRC :
  echo -a Ctrl+B > Bold
  echo -a Ctrl+U > Underlined
  echo -a Ctrl+R > Reverse Colors
  echo -a Ctrl+K X,Y > 7,15 Text Color (X=7), BackGround Color (Y=15)
  echo -a You can use the ";" character to break the line and to display the infos on more than one line.
  echo -a e.g: Title:!TIT;Artist:!ART will display:
  echo -a Title:****
  echo -a Artist:****
}
on 1:dialog:winampc:sclick:489:/set %winampc_cfg_language $$sfile($scriptdir*.wc2,Choose a WC2 language file,OK)
on 1:dialog:winampc:sclick:4:/echo -a $did(1)
on 1:dialog:winampc:sclick:21:/did -u winampc 22,10
on 1:dialog:winampc:sclick:22:/did -u winampc 21,10
on 1:dialog:winampc:sclick:10:/did -u winampc 21,22
on 1:dialog:winampc:sclick:23:/did -u winampc 24
on 1:dialog:winampc:sclick:24:/did -u winampc 23
on 1:dialog:winampc:sclick:20:/did -u winampc 27
on 1:dialog:winampc:sclick:27:/did -u winampc 20
on 1:dialog:winampc:sclick:13:/did -u winampc 14 | winampc_loadup $iif($did(13).state == 1,c) $+ F 18
on 1:dialog:winampc:sclick:14:/did -u winampc 13 | winampc_loadup $iif($did(14).state == 1,s) $+ F 18
on 1:dialog:winampc:sclick:16:/did -u winampc 17 | winampc_loadup $iif($did(16).state == 1,c) $+ F 19
on 1:dialog:winampc:sclick:17:/did -u winampc 16 | winampc_loadup $iif($did(17).state == 1,s) $+ F 19
on 1:dialog:winampc:sclick:117:/did -u winampc 118 | winampc_loadup $iif($did(117).state == 1,c) $+ F 119
on 1:dialog:winampc:sclick:118:/did -u winampc 117 | winampc_loadup $iif($did(118).state == 1,s) $+ F 119
on 1:dialog:winampc:sclick:121:/did -u winampc 122 | winampc_loadup $iif($did(121).state == 1,c) $+ F 123
on 1:dialog:winampc:sclick:122:/did -u winampc 121 | winampc_loadup $iif($did(122).state == 1,s) $+ F 123
on 1:dialog:winampc:init:0:{
  did -a winampc 35 %winampc_cfg_stopmsg
  did -a winampc 34 00:04:35
  did -a winampc 34 000435
  did -a winampc 34 00-04-35
  did -a winampc 34 00:04'35"
  did -a winampc 34 00 04 35
  did -c winampc 34 $gettok(%winampc_cfg_timedisplay,1,32)
  winampc_loadup F 18
  winampc_loadup F 19
  winampc_loadup F 119
  winampc_loadup F 123
  if %winampc_cfg_autosend == 1 { did -c winampc 20 }
  if %winampc_cfg_allchan == 1 { did -c winampc 21 }
  if %winampc_cfg_actchan == 1 { did -c winampc 22 }
  if %winampc_cfg_cmdmsg == 1 { did -c winampc 23 }
  if %winampc_cfg_cmdme == 1 { did -c winampc 24 }
  if %winampc_cfg_msg != $null { did -o winampc 1 1 %winampc_cfg_msg }
  if %winampc_dcctrigger != $null { did -o winampc 5 1 %winampc_dcctrigger }
  if %winampc_cfg_ve == 1 { did -c winampc 12 }
  if %winampc_cfg_vc == 1 { did -c winampc 13 | winampc_loadup cF 18 }
  if %winampc_cfg_vs == 1 { did -c winampc 14 | winampc_loadup sF 18 }
  if %winampc_cfg_de == 1 { did -c winampc 15 } 
  if %winampc_cfg_dc == 1 { did -c winampc 16 | winampc_loadup cF 19 }
  if %winampc_cfg_ds == 1 { did -c winampc 17 | winampc_loadup sF 19 }
  if %winampc_cfg_re == 1 { did -c winampc 116 } 
  if %winampc_cfg_rc == 1 { did -c winampc 117 | winampc_loadup cF 119 }
  if %winampc_cfg_rs == 1 { did -c winampc 118 | winampc_loadup sF 119 }
  if %winampc_cfg_ce == 1 { did -c winampc 120 }
  if %winampc_cfg_cc == 1 { did -c winampc 121 | winampc_loadup cF 123 }
  if %winampc_cfg_cs == 1 { did -c winampc 122 | winampc_loadup sF 123 }
  if %winampc_cfg_otherchan == 1 { did -c winampc 10 }
  if %winampc_cfg_otherchann != $null { did -o winampc 9 1 %winampc_cfg_otherchann }
  if %winampc_cfg_key1 != $null { did -c winampc 18 $findtok($didtok(winampc,18,32),%winampc_cfg_key1,32) }
  if %winampc_cfg_key2 != $null { did -c winampc 19 $findtok($didtok(winampc,19,32),%winampc_cfg_key2,32) }
  if %winampc_cfg_key3 != $null { did -c winampc 119 $findtok($didtok(winampc,119,32),%winampc_cfg_key3,32) }
  if %winampc_cfg_key4 != $null { did -c winampc 123 $findtok($didtok(winampc,123,32),%winampc_cfg_key4,32) }
  if %winampc_cfg_tbarupd == 1 { did -c winampc 26 }
  if %winampc_cfg_displaytimer == 1 { did -c winampc 27 | did -c winampc 33 $calc(%winampc_cfg_displaytime /30) | did -o winampc 32 1 $duration(%winampc_cfg_displaytime) }
  did -a winampc 6 $winampc_text(11)
  did -a winampc 998 $winampc_text(14)
  did -a winampc 101 $winampc_text(17)
  did -a winampc 102 $winampc_text(18)
  did -a winampc 103 $winampc_text(19)
  did -a winampc 105 $winampc_text(20)
  did -a winampc 106 $winampc_text(21)
  did -a winampc 107 $winampc_text(22)
  did -a winampc 108 $winampc_text(23)
  did -a winampc 109 $winampc_text(24)
  did -a winampc 110 $winampc_text(25)
  did -a winampc 112 $winampc_text(26)
  did -a winampc 113 $winampc_text(27)
  did -a winampc 114 $winampc_text(28)
  did -a winampc 115 $winampc_text(29)
  did -a winampc 125 $winampc_text(30)
  did -a winampc 111 $winampc_text(31)
  did -a winampc 28 $winampc_text(32)
  did -a winampc 29 $winampc_text(33)
  did -a winampc 30 $winampc_text(34)
  did -a winampc 995 $winampc_text(37)
  did -a winampc 7 $winampc_text(42)
  did -a winampc 999 $winampc_text(45)
  did -a winampc 25 $winampc_text(46)
  did -a winampc 20 $winampc_text(49)
  did -a winampc 21 $winampc_text(50)
  did -a winampc 23 $winampc_text(51)
  did -a winampc 24 $winampc_text(52)
  did -a winampc 22 $winampc_text(53)
  did -a winampc 10 $winampc_text(54)
  did -a winampc 26 $winampc_text(55)
  did -a winampc 27 $winampc_text(56)
  did -a winampc 996 $winampc_text(59)
  did -a winampc 994 $winampc_text(60)
  did -a winampc 36 $winampc_text(61)
  did -a winampc 8 $winampc_text(66)
  did -a winampc 12 $winampc_text(69)
  did -a winampc 15 $winampc_text(70)
  did -a winampc 116 $winampc_text(71)
  did -a winampc 120 $winampc_text(72)
  did -a winampc 489 $winampc_text(78)
  did -a winampc 11 $winampc_text(75)
  did -a winampc 37 $winampc_text(47)
  did -a winampc 2 $winampc_text(108)
  did -a winampc 3 $winampc_text(109)
  did -a winampc 4 $winampc_text(110)
}
on 1:dialog:winampc:sclick:2:{
  if $did(35) != $null { set %winampc_cfg_stopmsg $did(35) }
  else { set %winampc_cfg_stopmsg Winamp is Stopped. }
  if $did(34) != $null { set %winampc_cfg_timedisplay $did(34).sel $replace($did(34),00,!hrs,04,!min,35,!sec) }
  else { set %winampc_cfg_timedisplay 1 !hrs:!min:!sec }
  set %winampc_cfg_displaytime $calc($did(33).sel *30)
  set %winampc_cfg_displaytimer $did(27).state
  if %winampc_cfg_displaytimer == 1 { .timerwinampcautosay -oi 0 %winampc_cfg_displaytime /winampc_autosay }  
  else { .timerwinampcautosay off }
  set %winampc_cfg_autosend $did(20).state
  set %winampc_cfg_allchan $did(21).state
  set %winampc_cfg_actchan $did(22).state
  set %winampc_cfg_otherchan $did(10).state
  set %winampc_cfg_otherchann $did(9)
  if $did(22).state == 0 && $did(21).state == 0 && $did(10).state == 0 { set %winampc_cfg_actchan 1 }
  if $did(10).state == 1 && $did(9) == $null { set %winampc_cfg_otherchan 0 | set %winampc_cfg_actchan 1 }
  set %winampc_cfg_cmdmsg $did(23).state
  set %winampc_cfg_cmdme $did(24).state
  if $did(23).state == 0 && $did(24).state == 0 { set %winampc_cfg_cmdmsg 1 }
  set %winampc_cfg_ve $did(12).state
  set %winampc_cfg_vc $did(13).state
  set %winampc_cfg_vs $did(14).state
  set %winampc_cfg_de $did(15).state
  set %winampc_cfg_dc $did(16).state
  set %winampc_cfg_ds $did(17).state
  set %winampc_cfg_re $did(116).state
  set %winampc_cfg_rc $did(117).state
  set %winampc_cfg_rs $did(118).state
  set %winampc_cfg_ce $did(120).state
  set %winampc_cfg_cc $did(121).state
  set %winampc_cfg_cs $did(122).state
  set %winampc_cfg_tbarupd $did(26).state
  if $did(1) != $null { set %winampc_cfg_msg $did(1) }
  else { set %winampc_cfg_msg -WinAmp- !ART - !TIT [!TL] Download:!DCC }
  if $did(5) != $null { set %winampc_dcctrigger $did(5) }
  else { set %winampc_dcctrigger !Get }
  if $did(18) == $did(19) && %winampc_cfg_ve == 1 && %winampc_cfg_de == 1 { echo -a [ERROR] Do not set the same hotkey for the two commands. | halt }
  if $did(18) == $did(119) && %winampc_cfg_re == 1 && %winampc_cfg_de == 1 { echo -a [ERROR] Do not set the same hotkey for the two commands. | halt }
  if $did(19) == $did(119) && %winampc_cfg_re == 1 && %winampc_cfg_de == 1 { echo -a [ERROR] Do not set the same hotkey for the two commands. | halt }
  if $did(18) == $did(123) && %winampc_cfg_ve == 1 && %winampc_cfg_ce == 1 { echo -a [ERROR] Do not set the same hotkey for the two commands. | halt }
  if $did(123) == $did(119) && %winampc_cfg_re == 1 && %winampc_cfg_ce == 1 { echo -a [ERROR] Do not set the same hotkey for the two commands. | halt }
  if $did(19) == $did(123) && %winampc_cfg_ce == 1 && %winampc_cfg_de == 1 { echo -a [ERROR] Do not set the same hotkey for the two commands. | halt }
  if %winampc_cfg_key1 != $null { alias / $+ %winampc_cfg_key1 }
  if %winampc_cfg_key2 != $null { alias / $+ %winampc_cfg_key2 }
  if %winampc_cfg_key3 != $null { alias / $+ %winampc_cfg_key3 }
  if %winampc_cfg_key4 != $null { alias / $+ %winampc_cfg_key4 }
  set %winampc_cfg_key1 $did(18)
  set %winampc_cfg_key2 $did(19)
  set %winampc_cfg_key3 $did(119)
  set %winampc_cfg_key4 $did(123)
  if %winampc_cfg_ve == 1 { alias " $+ $scriptdirs_winampcontrolv2.ini" / $+ $did(18) /winampc_echosong }
  if %winampc_cfg_de == 1 { alias " $+ $scriptdirs_winampcontrolv2.ini" / $+ $did(19) /winampc_saysong }
  if %winampc_cfg_re == 1 { alias " $+ $scriptdirs_winampcontrolv2.ini" / $+ $did(119) /winampc_alarm }
  if %winampc_cfg_ce == 1 { alias " $+ $scriptdirs_winampcontrolv2.ini" / $+ $did(123) /winampc_ircplayer }
  set %winampc_msg $winampc_getmsg1(%winampc_cfg_msg)
}
on 1:LOAD:{
  winampc_reins
  .timercheckwinamp -oi 0 3 /if ( $!+($winampc_getinfo(tracksize),$winampc_getinfo(title)) != $!+(%winampc_checksong) ) { winampc_changetrack }
}
alias winampc_reins {
  if $exists($scriptdirWC2.dll) == $false { echo -a Please be sure you've unzipped WC2.dll into the scripts folder ( $+ $scriptdir $+ ) and then try to load the script again. | unload -rs winampcontrol_v2_1.mrc | halt }
  if $exists(WinampControl_v2.mrc) == $true { remini " $+ %winampc_winampdir $+ plugins\ $+ plugin.ini" "IRC Control Ex" | unset %winampc_winampdir | unload  -rs winampcontrol_v2.mrc | remove winampcontrol_v2.mrc | echo -a Old version removed. | goto end }
  if $exists(WinampControl_v2_1.mrc) == $true { unload -rs winampcontrol_v2_1.mrc | remove winampcontrol_v2_1.mrc | echo -a Old version removed. | goto end }
  if $exists(WinampControl_v2_2.mrc) == $true { unload -rs winampcontrol_v2_2.mrc | remove winampcontrol_v2_2.mrc | echo -a Old version removed. | goto end }
  if $exists(WinampControl_v2_3.mrc) == $true { unload -rs winampcontrol_v2_3.mrc | remove winampcontrol_v2_3.mrc | echo -a Old version removed. | goto end }
  if $exists(s_WinampControl_v2_3.mrc) == $true { unload -rs s_winampcontrol_v2_3.mrc | remove s_winampcontrol_v2_3.mrc | echo -a Old version removed. | goto end }
  if $exists(s_WinampControl_v2_4.mrc) == $true { unload -rs s_winampcontrol_v2_4.mrc | remove s_winampcontrol_v2_4.mrc | echo -a Old version removed. | goto end }
  if $exists($scriptdirs_WinampControl_v2_5.mrc) == $true { unload -rs " $+ $scriptdirs_winampcontrol_v2_5.mrc" | remove " $+ $scriptdirs_winampcontrol_v2_5.mrc" | echo -a Old version removed. | goto end }
  if $exists($scriptdirs_WinampControl_v2_6.mrc) == $true { unload -rs " $+ $scriptdirs_winampcontrol_v2_6.mrc" | remove " $+ $scriptdirs_winampcontrol_v2_6.mrc" | echo -a Old version removed. | goto end }
  if %winampc_cfg_msg == $null { set %winampc_cfg_msg -WinAmp- !ART - !TIT [!TL] Download:!DCC }
  echo -a Script values and default configuration loaded.
  :end
  if %winampc_cfg_language == $null { 
    set %winampc_cfg_language $scriptdirlang_English.wc2
    if $exists(%winampc_cfg_language) != $true { set %winampc_cfg_language $findfile($scriptdir,*.wc2,1) }
  }
  if %winampc_old_tb == $null { set %winampc_old_tb $titlebar }
  if %winampc_var == $null { set %winampc_var 1 }
  if %winampc_ins == $null { set %winampc_ins $day $date @ $time }
  if %winampc_cfg_timedisplay == $null { set %winampc_cfg_timedisplay !hrs:!min:!sec }
  if $exists($scriptdirs_winampcontrolv2.ini) != $true { write " $+ $scriptdirs_winampcontrolv2.ini" $chr(59) | load -a " $+ $scriptdirs_winampcontrolv2.ini" }
  echo -a s.Winamp Control v2.7 has been installed successfully.
  echo -a You can now configure the script.
  echo -a Report any bug to seldaek@hotmail.com
  winampc_cfg
}
menu menubar {
  Winamp-Plugin
  .$winampc_text(82):/winampc_cfg
  .$winampc_text(84):/winampc_alarm
  .$winampc_text(86):/winampc_ircplayer
  .$winampc_text(97)
  ..$winampc_text(98):/winampc_stats
  ..$winampc_text(99):/winampc_rsstats
}
menu status {
  s.Winamp Control v2.7
  .$winampc_text(90):/winampc_echosong
  .$winampc_text(96):/winampc_stats
  .$winampc_text(82):/winampc_cfg
  .$winampc_text(84):/winampc_alarm
  .$winampc_text(86):/winampc_ircplayer
}
menu channel {
  s.Winamp Control v2.7
  .$winampc_text(92):/winampc_saysong
  .$winampc_text(90):/winampc_echosong
  .$winampc_text(88):/winampc_pub $1-
  .$winampc_text(82):/winampc_cfg
  .$winampc_text(84):/winampc_alarm
  .$winampc_text(86):/winampc_ircplayer
}
menu query {
  s.Winamp Control v2.7
  .$winampc_text(92):/winampc_saysong
  .$winampc_text(90):/winampc_echosong
  .$winampc_text(104):/winampc_sendsong $1-
  .$winampc_text(88):/winampc_pub $1-
  .$winampc_text(82):/winampc_cfg
  .$winampc_text(84):/winampc_alarm
  .$winampc_text(86):/winampc_ircplayer
}
menu nicklist {
  s.Winamp Control v2.7
  .$winampc_text(104):/winampc_sendsong $1-
  .$winampc_text(88):/winampc_pvpub $1-
  .$winampc_text(82):/winampc_cfg
  .$winampc_text(84):/winampc_alarm
  .$winampc_text(86):/winampc_ircplayer
}
on *:CONNECT:{ 
  if $var(%winampc_played*,0) > 500 { unset %winampc_played* } 
  .timercheckwinamp -oi 0 3 /if ( $!+($winampc_getinfo(tracksize),$winampc_getinfo(title)) != $!+(%winampc_checksong) ) { winampc_changetrack } 
  if %winampc_cfg_displaytimer == 1 { .timerwinampcautosay -oi 0 %winampc_cfg_displaytime /winampc_autosay }
  if %winampc_cfg_language == $null { set %winampc_cfg_language $findfile($scriptdir,*.wc2,1) }
}
alias winampc_autosay {
  set -u3 %winampc_tempauto 1
  if %winampc_cfg_allchan == 1 {
    if %winampc_cfg_cmdme == 1 { winampc_go scid -a ame }
    else { winampc_go scid -a amsg }
  }
  elseif %winampc_cfg_actchan == 1 && $active != Status Window { 
    if %winampc_cfg_cmdme == 1 { winampc_go describe $active }
    else { winampc_go msg $active }
  }
  elseif %winampc_cfg_otherchan == 1 {
    if %winampc_cfg_cmdme == 1 { winampc_go describe %winampc_cfg_otherchann }
    else { winampc_go msg %winampc_cfg_otherchann }
  }
}
alias winampc_stats {
  echo -a You've played a total number of $calc(%winampc_var - 1) tracks since %winampc_ins ( Average : 1 track every $duration($calc(($ctime - $ctime(%winampc_ins)) / %winampc_var)) )
  echo -a You've now used this script for $duration($calc($ctime - $ctime(%winampc_ins)))
}
alias winampc_rsstats {
  if $input(Are you sure that you want to reset all the script's statistics ?,yv) == $yes { 
    unset %winampc_played*  
    set %winampc_var 1
    set %winampc_ins $day $date @ $time
  }
}
alias winampc_pvpub { 
  set %temp 1
  while %temp <= $0 {
    set %temp2 $ $+ %temp
    inc %temp 1
  }
  unset %temp*
}
alias winampc_pub { msg $active }
alias winampc_echosong { winampc_go echo -a }
alias winampc_saysong {
  if %winampc_cfg_cmdme == 1 { winampc_go me }
  else { winampc_go say }
}
alias winampc_go {
  winampc_upd_inf
  set %t 1
  if $numtok($winampc_getmsg2(%winampc_msg),59) == 1 { $1- $winampc_getmsg2(%winampc_msg) | halt }
  while %t <= $numtok($winampc_getmsg2(%winampc_msg),59) {
    $1- $gettok($winampc_getmsg2(%winampc_msg),%t,59)
    inc %t 1
  }
}
alias winampc_sendsong { 
  set %temp 1
  while %temp <= $0 {
    set %temp2 $ $+ %temp
    dcc send [ [ %temp2 ] ] %winampc_file 
    inc %temp 1
  }
  unset %temp*
}
alias winampc_uninst {
  set %temp $?="Type 'Yes' and clic OK if you're sure that you want to uninstall s.Winamp Control v2.7 !"
  if %temp != Yes { echo -a Thanks :) | halt }
  else {
    echo -a Uninstalling...
    winampc_uninstk
    titlebar %winampc_old_tb
    unset %winampc_*
    remove " $+ $scriptdirs_winampcontrolv2.ini"    
    unload -rs $scriptdirwinampcontrol_v2_7.mrc
  }
}
alias winampc_changetrack {
  if $winampc_getinfo(trackfilename) == $false { goto end }
  set %winampc_checksong $+($winampc_getinfo(tracksize),$winampc_getinfo(title))
  if %winampc_cfg_tbarupd == 1 { 
    set %winampc_titlebar $winampc_getinfo(artist) - $winampc_getinfo(title)
    titlebar > %winampc_titlebar 
  }
  inc %winampc_var 1
  if %winampc_cfg_autosend == 1 && %winampc_tempauto == $null {
    winampc_autosay
  }
  halt
  :end
  set %winampc_checksong $+($winampc_getinfo(tracksize),$winampc_getinfo(title))
  set %winampc_msg %winampc_cfg_stopmsg
  if %winampc_cfg_tbarupd == 1 { 
    set %winampc_titlebar Stopped
    titlebar > Stopped 
  }
}

alias winampc_upd_inf {
  if %winampc_titlebar == Stopped { halt }
  if $chr(33) $+ TIT isin %winampc_cfg_msg { 
    if $winampc_getinfo(title) != $false { set %winampc_title $winampc_getinfo(title) }
    else { set %winampc_title Unknown Tracktitle }
  }
  set %winampc_file $winampc_getinfo(trackfilename)
  if $chr(33) $+ FN isin %winampc_cfg_msg { 
    set %winampc_filename $nopath(%winampc_file)
  }
  if $chr(33) $+ Z isin %winampc_cfg_msg { 
    set %winampc_filesize $round($calc($winampc_getinfo(tracksize)/1048576),2)
  }
  ;set %winampc_played $+ %winampc_var $winampc_getinfo(trackfilename)
  if $chr(33) $+ TL isin %winampc_cfg_msg { 
    set %winampc_lenght $winampc_gettime2(tracksec)
  }
  if $chr(33) $+ R isin %winampc_cfg_msg { 
    set %winampc_srate $winampc_getinfo(samplerate)
  }
  if $chr(33) $+ B isin %winampc_cfg_msg { 
    set %winampc_brate $winampc_getinfo(bitrate)
  }
  if $chr(33) $+ V isin %winampc_cfg_msg { 
    set %winampc_version $winampc_getinfo(version)
  }
  if $chr(33) $+ POS isin %winampc_cfg_msg { 
    set %winampc_position $winampc_getinfo(trackno)
  }
  if $chr(33) $+ Y isin %winampc_cfg_msg { 
    if $winampc_getinfo(year) != $false { set %winampc_year $winampc_getinfo(year) }
    else { set %winampc_year N/A }
  }
  if $chr(33) $+ ART isin %winampc_cfg_msg { 
    if $winampc_getinfo(artist) != $false { set %winampc_artist $winampc_getinfo(artist) }
    else { set %winampc_arist Unknown Artist }
  }
  if $chr(33) $+ ALB isin %winampc_cfg_msg { 
    if $winampc_getinfo(album) != $false { set %winampc_album $winampc_getinfo(album) } 
    else { set %winampc_album Unknown Album }
  }
  if $chr(33) $+ G isin %winampc_cfg_msg { 
    if $winampc_getinfo(genre) != $false { set %winampc_genre $winampc_getinfo(genre) }
    else { set %winampc_genre N/A }
  }
  if $chr(33) $+ C isin %winampc_cfg_msg { 
    if $winampc_getinfo(comment) != $false { set %winampc_comment $winampc_getinfo(comment) }
    else { set %winampc_comment N/A }
  }
  set %winampc_msg $winampc_getmsg1(%winampc_cfg_msg)
}


alias winampc_getmsg1 {
  return $replace($1-,!FN,%winampc_filename,!Z,%winampc_filesize,!TL,%winampc_lenght,!R,%winampc_srate,!B,%winampc_brate,!V,%winampc_version,!POS,%winampc_position,!Y,%winampc_year,!ART,%winampc_artist,!ALB,%winampc_album,!G,%winampc_genre,!TIT,%winampc_title,!C,%winampc_comment,!MS,$iif($winampc_getinfo(channels) == 2,stereo,mono),!EX,$winampc_getinfo(filetype))
}
alias winampc_getmsg2 {
  return $replace($1-,!dcc,%winampc_dcctrigger,!TP,$winampc_gettime2(possec),!PER,$round($calc($winampc_getinfo(possec) / $winampc_getinfo(tracksec) *100),0))
}
alias winampc_getinfo {
  return $dll($scriptdirWC2.dll,WA_Link_Raw_Stats,$1)
}
alias winampc_gettime2 {
  if $dll($scriptdirWC2.dll,WA_Link_Raw_Stats,$1) >= 3600 {
    set -u0 %wc2.tmp0 $gmt($dll($scriptdirWC2.dll,WA_Link_Raw_Stats,$1),hh)
    set -u0 %wc2.tmp1 $gmt($dll($scriptdirWC2.dll,WA_Link_Raw_Stats,$1),nn)
    set -u0 %wc2.tmp2 $gmt($dll($scriptdirWC2.dll,WA_Link_Raw_Stats,$1),ss)
    return $replace($gettok(%winampc_cfg_timedisplay,2,32),!hrs,%wc2.tmp0,!min,%wc2.tmp1,!sec,%wc2.tmp2)
  }
  else {
    set -u0 %wc2.tmp1 $gmt($dll($scriptdirWC2.dll,WA_Link_Raw_Stats,$1),nn)
    set -u0 %wc2.tmp2 $gmt($dll($scriptdirWC2.dll,WA_Link_Raw_Stats,$1),ss)
    return $replace($right($gettok(%winampc_cfg_timedisplay,2,32),-5),!min,%wc2.tmp1,!sec,%wc2.tmp2)
  }
}
on 1:TEXT:*:*:{ if $1 == %winampc_dcctrigger && !DCC isin %winampc_cfg_msg { if $send($nick,1).status == active { .notice $nick Please wait ! You already have a transfer running... | halt } | dcc send $nick " $+ %winampc_file $+ " } }
;on 1:TEXT:*:*:{ if $1 == %winampc_dcctrigger && [ [ $+(%,winampc_played,$2) ] ] != $null && !DCC isin %winampc_cfg_msg { if $send($nick,1).status == active { .notice $nick Please wait ! You already have a transfer running... | halt } | dcc send $nick " $+ [ [ $+(%,winampc_played,$2) ] ] $+ " } }
alias winampc_alarm { dialog -m winampc_alarm winampc_alarm }
dialog winampc_alarm {
  title "[ s.Winamp Control - Alarm Clock ]"
  size -1 -1 183 103
  option dbu
  check "Active", 151, 7 8 36 8
  box "Timer 1", 100, 3 1 87 76
  text "Hour:", 190, 7 17 19 8
  combo 101, 32 16 28 100, size drop
  text "Minute:", 191, 7 28 25 8
  combo 102, 32 27 28 100, size drop
  text "Commands:", 192, 7 41 33 8
  check "Stop", 111, 45 40 35 10
  check "Play", 112, 45 48 35 10
  check "Set Volume to:", 113, 7 56 62 10
  text "0%", 120, 7 66 17 8
  scroll "", 121, 25 66 60 7, range 0 100 horizontal
  check "Active", 251, 97 8 38 8
  box "Timer 2", 200, 93 1 87 76
  text "Hour:", 290, 97 17 19 8
  combo 201, 122 16 28 100, size drop
  text "Minute:", 291, 97 28 25 8
  combo 202, 122 27 28 100, size drop
  text "Commands:", 292, 97 41 33 8
  check "Stop", 211, 135 40 35 10
  check "Play", 212, 135 48 35 10
  check "Set Volume to:", 213, 97 56 62 10
  text "0%", 220, 97 66 17 8
  scroll "", 221, 115 66 60 7, range 0 100 horizontal
  button "Save as Default", 301, 4 80 54 10
  button "Load Default", 302, 4 90 54 10
  button "Save as...", 303, 58 80 54 10
  button "Load...", 304, 58 90 54 10
  button "Activate", 998, 142 90 37 10, ok
  button "Cancel", 999, 142 80 37 10, cancel
}
alias winampc_loadtimers {
  set %t 1
  while %t <= 2 {
    if $timer(winampc $+ %t) != $null {
      did -c winampc_alarm %t $+ 51
      did -c winampc_alarm %t $+ 01 $calc($gettok($timer(winampc $+ %t).time,1,58) +1)
      did -c winampc_alarm %t $+ 02 $calc($gettok($timer(winampc $+ %t).time,2,58) +1)
      if stop isin $timer(winampc $+ %t).com { did -c winampc_alarm %t $+ 11 }
      if play isin $timer(winampc $+ %t).com { did -c winampc_alarm %t $+ 12 }
      if vol isin $timer(winampc $+ %t).com { did -c winampc_alarm %t $+ 13 | did -c winampc_alarm %t $+ 21 $remove($right($timer(winampc $+ %t).com,3),o,l) | did -o winampc_alarm %t $+ 20 1 $remove($right($timer(winampc $+ %t).com,3),o,l) $+ % }
    }
    inc %t 1
  }
}
on 1:dialog:winampc_alarm:init:0:{
  set %temp 00
  while %temp <= 23 {
    if %temp isnum 1-9 { did -a $dname 101,201 0 $+ %temp }
    else { did -a $dname 101,201 %temp }
    inc %temp 1
  }
  set %temp 00
  while %temp <= 59 {
    if %temp isnum 1-9 { did -a $dname 102,202 0 $+ %temp }
    else { did -a $dname 102,202 %temp }
    inc %temp 1
  }
  did -c $dname 101,102,201,202 1
  did -c $dname 151,251,111,212,213
  did -b $dname 113
  if $timer(winampc1) != $null || $timer(winampc2) != $null {
    did -u $dname 151,251,111,211,212,112,113,213
    did -e $dname 113
    winampc_loadtimers
  }
}
on 1:dialog:winampc_alarm:sclick:111:{ did -u $dname 112 | did -u $dname 113 | did -b $dname 113 }
on 1:dialog:winampc_alarm:sclick:112:{ did -u $dname 111 | did -e $dname 113 }
on 1:dialog:winampc_alarm:sclick:211:{ did -u $dname 212 | did -u $dname 213 | did -b $dname 213 }
on 1:dialog:winampc_alarm:sclick:212:{ did -u $dname 211 | did -e $dname 213 }
on 1:dialog:winampc_alarm:scroll:121:{ did -o $dname 120 1 $did(121).sel $+ % }
on 1:dialog:winampc_alarm:scroll:221:{ did -o $dname 220 1 $did(221).sel $+ % }
on 1:dialog:winampc_alarm:sclick:301:{
  set %winampc_tmpz Default
  winampc_savefile
}
on 1:dialog:winampc_alarm:sclick:302:{
  set %winampc_tmpz " $+ $scriptdirCfg_Default.ini"
  winampc_loadfile
}
on 1:dialog:winampc_alarm:sclick:303:{
  set %winampc_tmpz $?="Enter this configuration's name:"
  winampc_savefile
}
on 1:dialog:winampc_alarm:sclick:304:{
  set %winampc_tmpz $sfile($scriptdir*.ini,s.Winamp Control Configuration Files,Load it!)
  winampc_loadfile
}
on 1:dialog:winampc_alarm:sclick:998:{
  if $did(151).state == 1 { 
    set %tmp $did(101) $+ : $+ $did(102)
    if $did(111).state == 1 { .timerwinampc1 -oim %tmp 1 1 /dll " $+ $scriptdirWC2.dll" WA_Link_Command Stop }
    elseif $did(112).state == 1 && $did(113).state == 0 { .timerwinampc1 -oim %tmp 1 1 /dll " $+ $scriptdirWC2.dll" WA_Link_Command Play }
    elseif $did(112).state == 1 && $did(113).state == 1 { .timerwinampc1 -oim %tmp 1 1 /dll " $+ $scriptdirWC2.dll" WA_Link_Command Play $chr(124) /dll " $+ $scriptdirWC2.dll" WA_Link_Command Vol $did(121).sel }
  }
  else { .timerwinampc1 off }
  if $did(251).state == 1 {
    set %tmp $did(201) $+ : $+ $did(202)
    if $did(211).state == 1 { .timerwinampc2 -oim %tmp 1 1 /dll " $+ $scriptdirWC2.dll" WA_Link_Command Stop }
    elseif $did(212).state == 1 && $did(213).state == 0 { .timerwinampc2 -oim %tmp 1 1 /dll " $+ $scriptdirWC2.dll" WA_Link_Command Play }
    elseif $did(212).state == 1 && $did(213).state == 1 { .timerwinampc2 -oim %tmp 1 1 /dll " $+ $scriptdirWC2.dll" WA_Link_Command Play $chr(124) /dll " $+ $scriptdirWC2.dll" WA_Link_Command Vol $did(221).sel }
  }
  else { .timerwinampc2 off }
}
alias winampc_savefile {
  writeini " $+ $scriptdirCfg_ $+ %winampc_tmpz $+ .ini" Timer1 Active $did(151).state
  writeini " $+ $scriptdirCfg_ $+ %winampc_tmpz $+ .ini" Timer1 Hour $did(101)
  writeini " $+ $scriptdirCfg_ $+ %winampc_tmpz $+ .ini" Timer1 Min $did(102)
  writeini " $+ $scriptdirCfg_ $+ %winampc_tmpz $+ .ini" Timer1 Stop $did(111).state
  writeini " $+ $scriptdirCfg_ $+ %winampc_tmpz $+ .ini" Timer1 Play $did(112).state
  writeini " $+ $scriptdirCfg_ $+ %winampc_tmpz $+ .ini" Timer1 Vol $did(113).state
  writeini " $+ $scriptdirCfg_ $+ %winampc_tmpz $+ .ini" Timer1 Volper $did(121).sel
  writeini " $+ $scriptdirCfg_ $+ %winampc_tmpz $+ .ini" Timer2 Active $did(251).state
  writeini " $+ $scriptdirCfg_ $+ %winampc_tmpz $+ .ini" Timer2 Hour $did(201)
  writeini " $+ $scriptdirCfg_ $+ %winampc_tmpz $+ .ini" Timer2 Min $did(202)
  writeini " $+ $scriptdirCfg_ $+ %winampc_tmpz $+ .ini" Timer2 Stop $did(211).state
  writeini " $+ $scriptdirCfg_ $+ %winampc_tmpz $+ .ini" Timer2 Play $did(212).state
  writeini " $+ $scriptdirCfg_ $+ %winampc_tmpz $+ .ini" Timer2 Vol $did(213).state
  writeini " $+ $scriptdirCfg_ $+ %winampc_tmpz $+ .ini" Timer2 Volper $did(221).sel
}
alias winampc_loadfile {
  did -c winampc_alarm 101 $calc($readini(%winampc_tmpz,Timer1,Hour) +1)
  did -c winampc_alarm 102 $calc($readini(%winampc_tmpz,Timer1,Min) +1)
  did -c winampc_alarm 201 $calc($readini(%winampc_tmpz,Timer2,Hour) +1)
  did -c winampc_alarm 202 $calc($readini(%winampc_tmpz,Timer2,Min) +1)
  if $readini(%winampc_tmpz,Timer1,Stop) == 1 { did -c winampc_alarm 111 | did -u winampc_alarm 112 }
  if $readini(%winampc_tmpz,Timer1,Play) == 1 { did -c winampc_alarm 112 | did -u winampc_alarm 111 }
  if $readini(%winampc_tmpz,Timer2,Stop) == 1 { did -c winampc_alarm 211 | did -u winampc_alarm 212 }
  if $readini(%winampc_tmpz,Timer2,Play) == 1 { did -c winampc_alarm 212 | did -u winampc_alarm 211 }
  if $readini(%winampc_tmpz,Timer1,Vol) == 1 { did -c winampc_alarm 113 }
  else { did -u winampc_alarm 113 } 
  if $readini(%winampc_tmpz,Timer2,Vol) == 1 { did -c winampc_alarm 213 }
  else { did -u winampc_alarm 213 }
  if $readini(%winampc_tmpz,Timer1,Active) == 1 { did -c winampc_alarm 151 }
  else { did -u winampc_alarm 151 }
  if $readini(%winampc_tmpz,Timer2,Active) == 1 { did -c winampc_alarm 251 }
  else { did -u winampc_alarm 251 }
  did -c winampc_alarm 121 $readini(%winampc_tmpz,Timer1,Volper)
  did -c winampc_alarm 221 $readini(%winampc_tmpz,Timer2,Volper)
  did -o winampc_alarm 120 1 $did(winampc_alarm,121).sel $+ %
  did -o winampc_alarm 220 1 $did(winampc_alarm,221).sel $+ %
}
alias winampc_ircplayer { dialog -m winampc_ircplayer winampc_ircplayer }
dialog winampc_ircplayer {
  title "[ s.WC - Remote Control ]"
  size -1 -1 127 22
  option dbu
  button "Play", 1, 26 1 25 10
  button "Prev", 2, 1 1 25 10
  button "Options", 3, 101 11 25 10
  button "Pause", 5, 51 1 25 10
  button "Stop", 6, 76 1 25 10
  button "Next", 7, 101 1 25 10
  check "Shuffle", 8, 1 11 31 10
  check "Repeat", 9, 35 11 40 10
  button "ok", 888, 999 999 1 1, ok
  scroll "", 4, 1 23 100 6, range 0 100 horizontal
  text "x%", 10, 101 22 24 8, right
  button "Say it !", 11, 76 11 25 10
}
on 1:dialog:winampc_ircplayer:sclick:3:/dialog -m winampc_plopt winampc_plopt
on 1:dialog:winampc_ircplayer:sclick:1:/dll " $+ $scriptdirWC2.dll" WA_Link_Command Play
on 1:dialog:winampc_ircplayer:sclick:5:/dll " $+ $scriptdirWC2.dll" WA_Link_Command Pause
on 1:dialog:winampc_ircplayer:sclick:6:/dll " $+ $scriptdirWC2.dll" WA_Link_Command Stop
on 1:dialog:winampc_ircplayer:sclick:7:/dll " $+ $scriptdirWC2.dll" WA_Link_Command Next
on 1:dialog:winampc_ircplayer:sclick:2:/dll " $+ $scriptdirWC2.dll" WA_Link_Command Prev
on 1:dialog:winampc_ircplayer:sclick:8:/dll " $+ $scriptdirWC2.dll" WA_Link_Command Shuffle
on 1:dialog:winampc_ircplayer:sclick:9:/dll " $+ $scriptdirWC2.dll" WA_Link_Command Repeat
on 1:dialog:winampc_ircplayer:sclick:11:/winampc_saysong
on 1:dialog:winampc_ircplayer:scroll:4:{ did -o $dname 10 1 $did(4).sel $+ % | dll " $+ $scriptdirWC2.dll" WA_Link_Command Seek $did(4).sel }
on 1:dialog:winampc_ircplayer:init:*:{
  .timerWC2_remote -oi 0 2 /winampc_updateremote 
  if %winampc_cfg2_track == 1 { did -e winampc_ircplayer 4,10 
    dialog -sb winampc_ircplayer -1 -1 127 30 
    did -ra winampc_ircplayer 10 $round($calc($winampc_getinfo(possec) / $winampc_getinfo(tracksec) *100),0)) $+ %
    did -c winampc_ircplayer 4 $round($calc($winampc_getinfo(possec) / $winampc_getinfo(tracksec) *100),0)) 
  }
  else { did -b winampc_ircplayer 4,10 | dialog -sb winampc_ircplayer -1 -1 127 22 }
  if %winampc_cfg2_launch == 1 && $winampc_getinfo(state) == $ $+ WA_NOTRUNNING { dll " $+ $scriptdirWC2.dll" WA_Link_Command START }
  if ON isin $winampc_getinfo(getrepeat) { did -c $dname 9 }
  if ON isin $winampc_getinfo(getshuffle) { did -c $dname 8 }
}
on 1:dialog:winampc_ircplayer:close:*:{
  if %winampc_cfg2_exit == 1 && $winampc_getinfo(state) != $WA_NOTRUNNING { dll " $+ $scriptdirWC2.dll" WA_Link_Command CLOSE }
  .timerWC2_remote off
}
dialog winampc_plopt {
  title "[ s.WC - Remote Configuration ]"
  size -1 -1 104 44
  option dbu
  check "Launch Winamp with Remote ", 1, 1 0 118 10
  check "Close Winamp with Remote", 2, 1 10 118 10
  check "Enable Trackbar (Disable on slow cpu)", 3, 1 21 136 10
  button "Save", 4, 6 32 37 10, ok
  button "Cancel", 5, 60 32 37 10, cancel
}
on 1:dialog:winampc_plopt:sclick:4:{
  set %winampc_cfg2_launch $did(1).state
  set %winampc_cfg2_exit $did(2).state
  set %winampc_cfg2_track $did(3).state
  if $did(3).state == 1 { did -e winampc_ircplayer 4,10 | dialog -sb winampc_ircplayer -1 -1 127 30 | .timerWC2_remote -oi 0 2 /winampc_updateremote }
  else { did -b winampc_ircplayer 4,10 | dialog -sb winampc_ircplayer -1 -1 127 22 }
}
on 1:dialog:winampc_plopt:init:*:{
  if %winampc_cfg2_launch == 1 { did -c $dname 1 }
  if %winampc_cfg2_exit == 1 { did -c $dname 2 }
  if %winampc_cfg2_track == 1 { did -c $dname 3 }
}
alias winampc_updateremote {
  if $dialog(winampc_ircplayer) == $null { halt }
  if ON isin $winampc_getinfo(getrepeat) { did -c winampc_ircplayer 9 }
  else { did -u winampc_ircplayer 9 }
  if ON isin $winampc_getinfo(getshuffle) { did -c winampc_ircplayer 8 }
  else { did -u winampc_ircplayer 8 }
  if %winampc_cfg2_track == 1 {
    did -ra winampc_ircplayer 10 $round($calc($winampc_getinfo(possec) / $winampc_getinfo(tracksec) *100),0)) $+ %
    did -c winampc_ircplayer 4 $round($calc($winampc_getinfo(possec) / $winampc_getinfo(tracksec) *100),0)) 
  }
}
