alias mp3now! {
  if ($dialog(mp3now!)) { return }
  else { 
    if ($server == $null) { echo -s $theme(Info) $+ $theme(:)15 Fehler bist auf keinem Server Connected! | halt }
    else { dialog -md mp3now! mp3now! }
  }
}

dialog mp3now! {
  title "Mp3 Player"
  option pixels
  size -1 -1 398 343
  box , 1, 1 -1 296 260
  list 2, 3 9 291 246, size sort
  box , 3, 301 -1 96 300
  button "Play", 4, 310 22 78 17
  button "Zufall", 5, 310 46 78 17
  check "Repeat",12, 312 85 78 20
  check "Endlos...",14, 312 65 78 20
  check "Pause", 6, 310 115 78 17, push
  button "Stop", 8, 310 139 78 17
  box , 9, 305 160 88 6
  button "Aktualisieren", 11, 310 175 78 17
  button "Lschen", 13, 310 200 78 17
  button "Liste Erstellen", 15, 310 235 78 17
  button "Liste Anzeigen", 16, 310 260 78 17
  text "Gre:", 17, 3 265 33 13
  text "Bitrate:", 18, 175 265 35 13
  text "Lnge:", 19, 3 286 35 13
  text "Khz:", 20, 175 286 27 13
  text , 21, 44 265 59 13
  text , 22, 220 265 50 13
  text , 23, 44 286 59 13
  text , 24, 220 286 50 13
  box "Abspielen", 10, 1 304 260 36
  box , 25, 265 304 133 36
  button "Einstellungen", 26, 270 316 70 20
  button "Volume", 28, 349 316 44 20
  text %mp3playingnow, 27, 9 321 255 13
  button "mIRC", 666, 666 666 666 666, hide ok
}

on *:dialog:mp3now!:init:0: {
  if ( %mp3dir == $null ) { echo -a $theme(Fehler:)15,1 Kein Mp3 Verzeichnis gewhlt }
  else {
    var %mp3-seek = $findfile(%mp3dir,*.mp3,0,1,did -a mp3now! 2 $nopath($remove($replace($1-,_,)$1-,.mp3)))
    unset %mp3-p
  }
  if ( %mp3pause == on ) { did -c mp3now! 6 }
  if ( %mp3pause != on ) { did -m mp3now! 6 }
  if ( %mp3playingnow != $null ) { did -ra mp3now! 27 %mp3playingnow } | else { did -r mp3now! 27 }

  if (%mp3.endlos == $false) { set %mp3.endlos 0 }
  if (%mp3.endlos == 1) { set %mp3.unendlos 0 | did -c mp3now! 12 }
  elseif (%mp3.endlos == 0) { did -u mp3now! 12 }

  if (%mp3.unendlos == $false) { set %mp3.unendlos 0 }
  if (%mp3.unendlos == 1) { set %mp3.endlos 0 | did -c $dname 14 }
  elseif (%mp3.unendlos == 0) { did -u $dname 14 }

}

on *:dialog:mp3now!:sclick:12: {
  if ($did(12).state) { did -u $dname 14 | unset %mp3.unendlos | set %mp3.endlos 1 }
  elseif ($did(12).state == 0) { set %mp3.endlos 0 }
}

on *:dialog:mp3now!:sclick:14: {
  if ($did(14).state) { did -u $dname 12 | set %mp3.endlos 0 | set %mp3.unendlos 1 }
  elseif ($did(14).state == 0) { unset %mp3.play.random | set %mp3.unendlos 0 }

}
on *:dialog:mp3now!:sclick:2: { 
  set %mp3-p $did(2,$did(2).sel)
  set %mp3.no $did(2).sel
  jukeset
  did -r mp3now! 21,22,23,24
  did -a mp3now! 21 %junk-1
  did -a mp3now! 22 %junk-2
  did -a mp3now! 23 %junk-3
  did -a mp3now! 24 %junk-4
}

alias jukeset {
  set %mp3-cp " $+ %mp3dir $+ / $+ %mp3-p $+ .mp3 $+ "
  set %junk-1 $size(%mp3-cp)
  set %junk-2 $mp3(%mp3-cp).bitrate  $+ kbps
  set %junk-3 $mp3.time(%mp3-cp)
  set %junk-4 $mp3(%mp3-cp).sample $+ khz
  unset %mp3-cp
}

on *:dialog:mp3now!:sclick:4: {
  if ( %mp3-p == $null ) { echo -a $mp3now $theme(Fehler:)15,1 Keine Mp3 ausgewhlt | halt }
  else { 
    if ( %mp3.unendlos == 1) { set %mp3.play.normal 1 | unset %mp3.play.random }
    elseif ( %mp3.unendlos == 0) { unset %mp3.play.normal }
    set %musica " $+ %mp3dir $+ %mp3-p $+ .mp3 $+ "
    set %mp3-1 $nopath($remove($replace(%musica,_,)%musica,.mp3))) | set %mp3playingnow %mp3-1
    .timer 1 1 unset %mp3-1 | if ( $dialog(mp3now!)) { did -ra mp3now! 27 %mp3playingnow } | else { return }
  mp3play }
}

on *:dialog:mp3now!:sclick:5: {
  if ( %mp3.unendlos == 1) { set %mp3.play.random 1 | unset %mp3.play.normal }
  elseif ( %mp3.unendlos == 0) { unset %mp3.play.random }
  unset %mp3.play.normal
  set %musica $findfile(%mp3dir,*.mp3,$rand(1,$findfile(%mp3dir,*.mp3,0)))
  set %mp3-1 $nopath($remove($replace(%musica,_,)%musica,.mp3))) | set %mp3playingnow %mp3-1 | did -ra mp3now! 27 %mp3playingnow
  mp3play
}

on *:dialog:mp3now!:sclick:6: { if ( $did(6).state == 1 ) { mp3pause } | else { mp3resume } }
on *:dialog:mp3now!:sclick:8: { unset %mp3playingnow | did -r mp3now! 27 | mp3stop }
on *:dialog:mp3now!:sclick:11: { did -r mp3now! 2 | var %mp3-seek = $findfile(%mp3dir,*.mp3,0,1,did -a mp3now! 2 $nopath($remove($replace($1-,_,)$1-,.mp3))) }
on *:dialog:mp3now!:sclick:13: { if ( $did(mp3now!,2).sel == $null ) || ( $did(mp3now!,2).sel == 0 ) { halt } | else { did -d mp3now! 2 $did(mp3now!,2).sel } }
on *:dialog:mp3now!:sclick:15: { .timer 1 0 mp3listax }
on *:dialog:mp3now!:sclick:16: { //run %mp3list $+ .txt }
on *:dialog:mp3now!:sclick:26: { mp3now!setup }
on *:dialog:mp3now!:sclick:28: { mp3now!vol }

alias addlist { var %xadd = $file="Mp3(s) zur Liste Hinzufgen" c:/*.mp3 | if ( %xadd != $null ) { did -i mp3now! 2 1 $nopath($remove($replace(%xadd,_,)%xadd,.mp3))) } | else { halt } }
alias size { if ($exists($1-)) && ($lof($1) isnum) return $round($calc($lof($1) / 1048576),2) $+ mb }
alias mp3.time { var %mp3tmp = $replace($duration($round($calc($lof($1) / 16000),0)),secs,s,mins,m,sec,s,min,m) | return $gettok(%mp3tmp,1,32) $+ $gettok(%mp3tmp,2,32) }
alias som { vol -v $calc(6553 * %vs) }
alias +som { if ( %vs >= 10 ) { halt } | else { inc %vs | som | did -ra mp3now!vol 5 %vs $+ 0 $+ % } }
alias -som { if ( %vs =< 0 ) { halt } | else { dec %vs | som | did -ra mp3now!vol 5 %vs $+ 0 $+ % } }
alias mp3now { return 15,1 Mp3 Player }

alias mp3now!vol {
  if ($dialog(mp3now!vol)) { return }
  else { dialog -md mp3now!vol mp3now!vol }
}

dialog mp3now!vol {
  title "Volume"
  size 57 102 136 71
  edit , 5, 8 20 77 23, multi read return
  button "-", 3, 102 38 27 25
  button "+", 2, 102 6 27 25
  button "mIRC", 666, 666 666 666 666, hide Ok
}

on *:dialog:mp3now!vol:sclick:2: { +som }
on *:dialog:mp3now!vol:sclick:3: { -som }
on *:dialog:mp3now!vol:init:0: { did -ra mp3now!vol 5 %vs $+ 0 $+ % }

alias mp3now!extras {
  if ($dialog(mp3now!extras)) { return }
  else { dialog -md mp3now!extras mp3now!extras }
}

dialog mp3now!extras {
  title "Mp3 Player Extras"
  size -1 -1 178 60
  box "", 1, 1 -3 176 62
  check "Mp3 Download AN", 4, 9 25 163 13
  check "Starte Mp3 Player beim Start", 2, 9 41 163 13
  check "Beim Beenden zurcksetzen", 5, 9 9 164 13
  button "mIRC", 666, 666 666 666 666, hide Ok
}

on *:dialog:mp3now!extras:sclick:4: { if ( $did(4).state == 1 ) { set %mpd-1 %mpd | set %mpd 2 | set %s2 1 | .enable #mp3get }
if ( $did(4).state == 0 ) { set %s2 0 | set %mpd %mpd-1 | .disable #getmp3 } }
on *:dialog:mp3now!extras:sclick:2: { if ( $did(2).state == 1 ) { set %s3 1 | .enable #startmp3 }
if ( $did(2).state == 0 ) { set %s3 0 | .disable #startmp3 } }
on *:dialog:mp3now!extras:sclick:5: { if ( $did(5).state == 1 ) { set %s4 1 | .enable #exitmp3 }
if ( $did(5).state == 0 ) { set %s4 0 | .disable #exitmp3 } }
on *:dialog:mp3now!extras:init:*: {
  if ( %s2 == 1 ) { did -c mp3now!extras 4 }
  if ( %s3 == 1 ) { did -c mp3now!extras 2 }
  if ( %s4 == 1 ) { did -c mp3now!extras 5 }
}

alias mp3now!setup {
  if ($dialog(mp3now!setup)) { return }
  else { dialog -md mp3now!setup mp3now!setup }
}

dialog mp3now!setup {
  title "Mp3 Player Einstellungen"
  size -1 -1 185 143
  box "Einstellungen", 1, 1 0 85 93
  button "Verzeichnis", 2, 8 20 67 25
  button "Extras", 4, 8 55 67 25
  box "Liste", 5, 90 0 88 93
  button "Liste Erstellen", 6, 96 20 75 25
  button "Liste Anzeigen", 7, 96 55 75 25
  combo 8, 25 110 136 84, drop size
  box "Anzeige:", 9, 1 95 178 44
  button "mIRC", 666, 666 666 666 666, hide Ok
}
on *:dialog:mp3now!setup:init:0:{
  did -a mp3now!setup 8 Im Channel
  did -a mp3now!setup 8 Im Channel mit Download
  did -a mp3now!setup 8 Nur im aktiven Channel
  did -a mp3now!setup 8 Nur fr mich
  did -a mp3now!setup 8 Nicht Anzeigen
  did -z mp3now!setup 8
  did -c mp3now!setup 8 %mpd
}


on *:dialog:mp3now!setup:sclick:2: { .timer 1 0 mp3dir }
on *:dialog:mp3now!setup:sclick:4: { mp3now!extras }
on *:dialog:mp3now!setup:sclick:6: { .timer 1 0 mp3listax }
on *:dialog:mp3now!setup:sclick:7: { //run $mircdir $+ %mp3list $+ .txt }
on *:dialog:mp3now!setup:sclick:8: { set %mpd $did(8).sel }

menu menubar,channel,nicklist {
  Mp3 Player
  .Simple Mp3 Player: simplemp3play
  .Advanced Mp3 Player: mp3now! 
  .-
  .Einstellungen
  ..Generell: mp3now!setup
  ..-
  ..Verzeichnis: mp3dir
  ..Extras: mp3now!extras
  .-
  .Steuerung...
  ..Stop: mp3stop
  ..Pause: mp3pause
  ..Weiter: mp3resume
  ..-
  ..Volume: mp3now!vol
  .-
  .Mp3 Liste: mp3listax
  .Check Mp3 Liste: //run $mircdir $+ / $+ %mp3list $+ .txt
}

alias mp3stop {
  if ( $inmp3 == $true ) { .splay -wmp STOP 
    echo -s $mp3now $theme(Mp3:)15,1 ( $+ $nopath($remove(%musica,.mp3))) $+ ) stoped
    .timer 1 0 unset %musica | unset %mp3playingnow
    window -c @mp3
    if ($dialog(mp3now!)) { did -r mp3now! 27 | unset %mp3playingnow }
    else { unset %mp3playingnow }
  }
  if ( $inmp3 == $false ) { return } 
}

alias mp3pause {
  if ( $inmp3 == $true ) { .splay -wmp PAUSE | set %mp3pause on }
  if ( $inmp3 == $false ) { halt }
}

alias mp3resume {
  if ( %mp3pause == on ) { .splay -wmp RESUME | set %mp3pause off }
  else { halt }
}

alias mp3dir { 
  set %mp3dir $sdir="Mp3 Verzeichnis Whlen"
  if ( %mp3dir == $null ) { echo -s $theme(Fehler:) 15,1Mp3 Verzeichnis Fehler! }
  if ( %mp3dir != $null ) { echo -s $theme(Info) $+ $theme(:)15 Verzeichnis: ' $+ %mp3dir $+ ' wurde festgelegt }
}

alias mp3play {

  .timer 1 2 .splay %musica
  if ($dialog(mp3now!)) { did -ra mp3now! 27 %mp3playingnow }
  else { return }
  if ( %mpd == 1 ) { if ( $server != $null ) && ( %sc != s ) { amsg $theme(Mp3:)15 ( $+ $nopath($remove(%musica,.mp3))) $+ ) $mp3.time(%musica) $+  $+ $theme(!)15 $+ $size(%musica) $+  $+ $theme(!)15 $+ $mp3(%musica).bitrate $+ kbps $+  $+ $theme(!)15 $+ $mp3(%musica).sample $+ khz  $+ %c1 $+ :: $mp3now | halt } | else { if ( $server != $null ) { amsg $theme(Mp3:)15 ( $+ $nopath($remove(%musica,.mp3))) $+ )  $+ %c1 $+ :: $mp3now } | else { halt } } }
  if ( %mpd == 2 ) { if ( $server != $null ) && ( %sc != s ) { amsg $theme(Mp3:)15 ( $+ $nopath($remove(%musica,.mp3))) $+ ) $mp3.time(%musica) $+  $+ $theme(!)15 $+ $size(%musica) $+  $+ $theme(!)15 $+ $mp3(%musica).bitrate $+ kbps $+  $+ $theme(!)15 $+ $mp3(%musica).sample $+ khz  $+ %c1 $+ :: $theme(Download:) 15,1@mp3 $me $nopath(%musica)  $+ %c1 $+ :: $mp3now | halt } | else { if ( $server != $null ) { amsg $theme(Mp3:)15,1 ( $+ $nopath($remove(%musica,.mp3))) $+ ) $theme(Download:) 15,1@mp3 $me $nopath(%musica)  $+ %c1 $+ :: $mp3now } | else { halt } } }
  if ( %mpd == 4 ) { statusd }
  if ( %mpd == 5 ) { halt }
  if ( %mpd == 3 ) { if ( $server != $null ) && ( %sc != s ) && ($chan != $null) { msg # $theme(Mp3:)15 ( $+ $nopath($remove(%musica,.mp3))) $+ ) $mp3.time(%musica) $+  $+ $theme(!)15 $+ $size(%musica) $+  $+ $theme(!)15 $+ $mp3(%musica).bitrate $+ kbps $+  $+ $theme(!)15 $+ $mp3(%musica).sample $+ khz  $+ %c1 $+ :: $mp3now | halt } | else { if ( $server != $null ) && ($chan != $Null) { msg # $theme(Mp3:)15 ( $+ $nopath($remove(%musica,.mp3))) $+ )  $+ %c1 $+ :: $mp3now } | else { halt } } }
}  

#mp3finish on
on *:MP3END: { 
  if ( %musica == $null) { halt }
  if ( %musica != $Null) { echo -s $mp3now $theme(Mp3:)15,1 ( $+ $nopath($remove(%musica,.mp3))) $+ ) fertig }
  if ( %mp3.endlos == $false) { set %mp3.endlos 0 }
  if ( %mp3.endlos == 1) { mp3play } 
  if ($dialog(mp3now!)) {
    if ( %mp3.unendlos == 1) { 
      if ( %mp3.play.random == 1) {
        if ( %mp3.unendlos == 1) { set %mp3.play.random 1 | unset %mp3.play.normal }
        elseif ( %mp3.unendlos == 0) { unset %mp3.play.random }
        set %musica $findfile(%mp3dir,*.mp3,$rand(1,$findfile(%mp3dir,*.mp3,0)))
        set %mp3-1 $nopath($remove($replace(%musica,_,)%musica,.mp3))) | set %mp3playingnow %mp3-1 | did -ra mp3now! 27 %mp3playingnow
        mp3play
      }
      if ( %mp3.play.normal == 1) {
        if ( %mp3.unendlos == 1) { set %mp3.play.normal 1 | unset %mp3.play.random }
        elseif ( %mp3.unendlos == 0) { unset %mp3.play.normal }
        inc %mp3.no
        did -c mp3now! 2 %mp3.no
        set %mp3-p $did(mp3now!,2).seltext 
        jukeset
        did -r mp3now! 21,22,23,24
        did -a mp3now! 21 %junk-1
        did -a mp3now! 22 %junk-2
        did -a mp3now! 23 %junk-3
        did -a mp3now! 24 %junk-4
        if ( %mp3-p == $null ) { echo -a $mp3now $theme(Fehler:)15,1 Keine Mp3 mehr ausgewhlt | halt }
        set %musica " $+ %mp3dir $+ %mp3-p $+ .mp3 $+ "
        set %mp3-1 $nopath($remove($replace(%musica,_,)%musica,.mp3))) | set %mp3playingnow %mp3-1
        .timer 1 1 unset %mp3-1 | if ( $dialog(mp3now!)) { did -ra mp3now! 27 %mp3playingnow } | else { return }
        mp3play
      }

    }
  }
  else { halt }

  unset %musica | set %mp3pause off
  .window -c @mp3
  if ($dialog(mp3now!)) { did -r mp3now! 27 | unset %mp3playingnow }
  else { unset %mp3playingnow }

}

#mp3finish end

alias mp3listax {
  set %mp3list $?"Verzeichnis/Dateiname?" | if (%mp3list == $null) { set %mp3list listmp3 }
  write -c %mp3list $+ .txt
  var %tmp = $findfile(%mp3dir,*.mp3,0,write %mp3list $+ .txt $nopath($1-) $str(., $calc(73 - $len($nopath($1-)))) $size($1-) $+ :: $+ $mp3($1-).bitrate $+ kbps $+ :: $+ $mp3.time($1-))
  write %mp3list $+ .txt $str(,97)
  run %mp3list $+ .txt
  echo -a $theme(Fertig:)15,1 Mp3 Liste: %mp3list $+ .txt
}

alias statusd {
  window -ak0 @mp3
  window @mp3 0 336 387 140
  aline @mp3  $mp3now $str(,29) $mp3now
  aline @mp3  1,1x $+ $theme(Mp3 Name:)15,1 $nopath(%musica)
  aline @mp3  1,1x.xxxxx $+ $theme(Titel:)15,1 $mp3(%musica).title
  aline @mp3  1,1xxx. $+ $theme(Gruppe:)15,1 $mp3(%musica).artist
  aline @mp3  1,1xxxx. $+ $theme(Lnge:)15,1 $mp3.time(%musica)
  aline @mp3  1,1xxxx $+ $theme(Bitrate:)15,1 $mp3(%musica).bitrate $+ kbps
  aline @mp3  $mp3now $str(,29) $mp3now
  aline @mp3  ---------------------------------------
}


#mp3get on
on *:text:$(@mp3 $me $+ *):*: {
  if ($nick == $me) { halt }
  else {
    if ( $3 == $null ) { .msg $nick $mp3now - 15,1Du hast kein Mp3 Angegeben | halt }
    else { 
      var %get-var %mp3dir $+ $3-
      if ( $exists(%get-var) == $true ) { .msg $nick $mp3now $theme(Sende)  $+ %c1 $+ ( $nopath(%get-var)  $+ %c1 $+ ) | dcc send $nick %get-var | halt }
      if ( $exists(%get-var) == $false ) { .msg $nick $mp3now 15,1Datei nicht gefunden | halt }
    }
  }
}
#mp3get end

#startmp3 off
on *:start:mp3now!
#startmp3 end

#exitmp3 off
on *:exit:unset %musica | mp3stop
#exitmp3 end

alias winampsong {
  return $dll(wIRC1.dll, winampsong, 0)
}

alias winampsongpath {
  return $dll(wIRC1.dll, winampsongpath, 0)
}

alias winampid3title {
  return $dll(wIRC1.dll, winampid3title, 0)
}

alias winampid3artist {
  return $dll(wIRC1.dll, winampid3artist, 0)
}

alias winampsongsize {
  return $dll(wIRC1.dll, winampsongsize, 0)
}

alias winampsonglength {
  return $dll(wIRC1.dll, winampsonglength, 0)
}

alias winampsongbitrate {
  return $dll(wIRC1.dll, winampsongbitrate, 0)
}

alias winampsongsamplefreq {
  return $dll(wIRC1.dll, winampsongsamplefreq, 0)
}
